package w83a.objects;

import java.io.Serializable;
import java.util.Locale;

public abstract class W83aBaseObject implements Serializable, Comparable{

	/**
	 * Serial version
	 */
	private static final long serialVersionUID = 385027792298587569L;
	
	/**
	 * Locale en el que se presentaran los datos en pantalla
	 */
	private Locale locale;
	private boolean compareByValueBol=false; // NOPMD by ifernandez on 5/3/10 1:58 PM
	

	/**
	 * Mtodo que devuelve el idioma del locale. 
	 * @return Lenguaje del locale. Si el locale es nulo, devolver lenguaje null.
	 */
	public String getLanguage() {
		if(this.locale == null){
			return null;
		}else{
			return this.locale.getLanguage();
		}
	}
	
	/**
	 * Mtodo que asigna locale pasado como parmetro.
	 * @param locale Locale que asignamos al atributo locale de la clase.
	 */
	public void setLocale(Locale locale){
		this.locale = locale;
	}
	
	/**
	 * Mtodo que devuelve el locale de la clase
	 * @return Locale de la clase.
	 */
	public Locale getLocale (){
		return this.locale;
	}
	
	/**
	 * Mtodo abstracto que deben implementar las subclases, empleado para obtener el 
	 * valor de un campo identificador de una clase en la presentacin.
	 * @return String con el valor del atributo id (campo identificador) de una clase.
	 */
	public abstract String getValue();
	
	/**
	 * Mtodo abstracto que deben implementar las subclases, empleado para obtener el
	 * valor de un campo descriptivo de una clase. El valor de este campo depender del
	 * locale.
	 * @return String con el valor del atributo value (campo descriptivo) de una clase.
	 */
	public abstract String getId();
	
	/**
	 * Mtodo que compara lexicogrficamente este objeto W83aBaseObject con otro objeto W83aBaseObject 
	 * pasado como parmetro, atendiendo a su id.
	 * @param obj Objeto W83aBaseObject con el que se compara.
	 * @return Valor 0 si el valor es el mismo; valor menor que 0 si este objeto es menor que el pasado como parmetro; 
	 * valor mayor que 0 si este objeto es mayor que el objeto pasado como parmetro.
	 */
	public int compareById(W83aBaseObject obj){
		String s1 = (String)this.getId();
		String s2 = (String)obj.getId();

		return s1.toLowerCase().compareTo(s2.toLowerCase());
	}
	
	/**
	 * Mtodo que compara lexicogrficamente este objeto W83aBaseObject con otro objeto W83aBaseObject 
	 * pasado como parmetro, atendiendo a su value.
	 * @param obj Objeto W83aBaseObject con el que se compara.
	 * @return Valor 0 si el valor es el mismo; valor menor que 0 si este objeto es menor que el pasado como parmetro; 
	 * valor mayor que 0 si este objeto es mayor que el objeto pasado como parmetro.
	 */
	public int compareByValue(W83aBaseObject obj){
		String s1 = (String)this.getValue();
		String s2 = (String)obj.getValue();

		return s1.toLowerCase().compareTo(s2.toLowerCase());
	}

	/**
	 * @param o {@link Object}
	 * @return 0 o 1
	 */
	public int compareTo(Object o){
		if(this.compareByValueBol){
			return this.compareByValue((W83aBaseObject)o);
		}else{
			 return this.compareById((W83aBaseObject)o);
		}
	}

	/**
	 * @param theCompareByValue valor a comparar
	 */
	public void setCompareByValue(boolean theCompareByValue) {
		this.compareByValueBol = theCompareByValue;
	}

	/**
	 * @param obj {@link Object}
	 * @return boolean
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		
		if(obj instanceof W83aBaseObject && obj.getClass().equals(this.getClass()) && this.getId() != null){
			 return this.getId().equals(((W83aBaseObject)obj).getId());			
		}else{
			return super.equals(obj);
		}
	}
}

